

globals [
 imported-jobs ;;an indicator whether the csv data file import was successful
 time ;;tracks the simulation time in minutes, while every tick represents five minutes.
 global-link ;;mean of displayed links, between 0 and 1
 global-reciproticy ;;mean reciprocity, between 0 and 1
 reciprocity-01
 reciprocity-02
 reciprocity-03
 reciprocity-12
 reciprocity-13
 reciprocity-23
 temp-color-store
 task-slot-1-full
 task-slot-2-full
 task-slot-3-full
 task-slot-4-full
]

links-own [
 paffect ;;positive affect values for each link, ranging [0,1]
 naffect ;;negative affect values for each link, ranging [0,1]
 inform ;;instrumental: informational values for each link, ranging [0,1]
 behave ;;instrumental: behavioral values for each link, ranging [0,1]
]

extensions[csv]

breed [astronauts astronaut]
astronauts-own [
 role
 ;;personality
 extraversion
 conscientiousness
 emotional_stability
 agreeableness
 openness
 ;;need to import individual differences collected from HERA
]

breed [jobs job]
;;have a task importer  where things you want to knwo about a job are defined and set
;;make a csv first column is when task is introduced, task duration, four columns for each hera member
;;comment code
jobs-own[
 start-time
 duration
 assigned-to-CMD
 assigned-to-FE
 assigned-to-MS1
 assigned-to-MS2
 teaming-episode
]

;; Routine for the ABM Simulation setup
to setup
  clear-all
  set time 0
  setup-agents
  setup-links
  reset-ticks
  set imported-jobs False
  import-jobs
  refresh
end

;;Creates the four agents for the model: CMD, FE, MS1, MS2
to setup-agents
  create-astronauts 1 [
    set role "CMD"
    set shape "astronaut"
    set size 4
    set color white
    set xcor 0
    set ycor 9
  ]
  ask patch 1 5 [
    set plabel "CMD"
  ]
  create-astronauts 1 [
    set role "FE"
    set shape "astronaut"
    set size 4
    set color white
    set xcor 0
    set ycor -9
  ]
  ask patch 0.3 -5 [
    set plabel "FE"
  ]
  create-astronauts 1 [
    set role "MS1"
    set shape "astronaut"
    set size 4
    set color white
    set xcor -9
    set ycor 0
  ]
  ask patch -5 0 [
    set plabel "MS1"
  ]
  create-astronauts 1 [
    set role "MS2"
    set shape "astronaut"
    set size 4
    set color white
    set xcor 9
    set ycor 0
  ]
  ask patch 6 0 [
    set plabel "MS2"
  ]
end

;; Creates the setup for all links for the model
to setup-links
  ;ask all turtles to create a link to every other turtle that's not itself
  ask astronauts with [who != 0][
    create-link-to turtle 0
  ]
  ask astronauts with [who != 1][
    create-link-to turtle 1
  ]
  ask astronauts with [who != 2][
    create-link-to turtle 2
  ]
  ask astronauts with [who != 3][
    create-link-to turtle 3
  ]
  ask links [
   ;;set color rgb 255 0 0
   set color approximate-hsb 0 90 70
   set shape "curvy"
   set thickness 0.2
  ]
end

to update-paffect
  ask links [
   set paffect (paffect + random-float .25 - random-float .20)
   if paffect > 1 [set paffect 1]
   if paffect < 0 [set paffect 0]
  ]
end

to update-naffect
  ask links [
   set naffect (naffect - random-float .25 + random-float .20)
   if naffect > 1 [set naffect 1]
   if naffect < 0 [set naffect 0]
  ]
end

to update-inform
  ask links [
   set inform (inform + random-float .25 - random-float .20)
   if inform > 1 [set inform 1]
   if inform < 0 [set inform 0]
  ]
end

to update-behave
  ask links [
   set behave (behave + random-float .25 - random-float .20)
   if behave > 1 [set behave 1]
   if behave < 0 [set behave 0]
  ]
end

to display-paffect
  ;;colors network links for positve affect
  ask links [
   set color approximate-hsb (paffect * 140) 90 70
  ]
  ;;changes global positve affect variables
  set global-link (([paffect] of link 0 1 + [paffect] of link 0 2 + [paffect] of link 0 3 + [paffect] of link 1 0 + [paffect] of link 1 2 + [paffect] of link 1 3 + [paffect] of link 2 0 + [paffect] of link 2 1 + [paffect] of link 2 3 + [paffect] of link 3 0 + [paffect] of link 3 1 + [paffect] of link 3 2) / 12)
  set reciprocity-01 abs ([paffect] of link 0 1 - [paffect] of link 1 0)
  set reciprocity-02 abs ([paffect] of link 0 2 - [paffect] of link 2 0)
  set reciprocity-03 abs ([paffect] of link 0 3 - [paffect] of link 3 0)
  set reciprocity-12 abs ([paffect] of link 1 2 - [paffect] of link 2 1)
  set reciprocity-13 abs ([paffect] of link 1 3 - [paffect] of link 3 1)
  set reciprocity-23 abs ([paffect] of link 2 3 - [paffect] of link 3 2)
end

to display-naffect
  ask links [
   set color approximate-hsb (naffect * 140) 90 70
  ]
  ;;changes global negative affect variables
  set global-link (([naffect] of link 0 1 + [naffect] of link 0 2 + [naffect] of link 0 3 + [naffect] of link 1 0 + [naffect] of link 1 2 + [naffect] of link 1 3 + [naffect] of link 2 0 + [naffect] of link 2 1 + [naffect] of link 2 3 + [naffect] of link 3 0 + [naffect] of link 3 1 + [naffect] of link 3 2) / 12)
  set reciprocity-01 abs ([naffect] of link 0 1 - [naffect] of link 1 0)
  set reciprocity-02 abs ([naffect] of link 0 2 - [naffect] of link 2 0)
  set reciprocity-03 abs ([naffect] of link 0 3 - [naffect] of link 3 0)
  set reciprocity-12 abs ([naffect] of link 1 2 - [naffect] of link 2 1)
  set reciprocity-13 abs ([naffect] of link 1 3 - [naffect] of link 3 1)
  set reciprocity-23 abs ([naffect] of link 2 3 - [naffect] of link 3 2)
end

to display-inform
  ask links [
   set color approximate-hsb (inform * 140) 90 70
  ]
  ;;changes global informational tie variables
  set global-link (([inform] of link 0 1 + [inform] of link 0 2 + [inform] of link 0 3 + [inform] of link 1 0 + [inform] of link 1 2 + [inform] of link 1 3 + [inform] of link 2 0 + [inform] of link 2 1 + [inform] of link 2 3 + [inform] of link 3 0 + [inform] of link 3 1 + [inform] of link 3 2) / 12)
  set reciprocity-01 abs ([inform] of link 0 1 - [inform] of link 1 0)
  set reciprocity-02 abs ([inform] of link 0 2 - [inform] of link 2 0)
  set reciprocity-03 abs ([inform] of link 0 3 - [inform] of link 3 0)
  set reciprocity-12 abs ([inform] of link 1 2 - [inform] of link 2 1)
  set reciprocity-13 abs ([inform] of link 1 3 - [inform] of link 3 1)
  set reciprocity-23 abs ([inform] of link 2 3 - [inform] of link 3 2)
end

to display-behave
  ask links [
   set color approximate-hsb (behave * 140) 90 70
  ]
  ;;changes global behavioral tie variables
  set global-link (([behave] of link 0 1 + [behave] of link 0 2 + [behave] of link 0 3 + [behave] of link 1 0 + [behave] of link 1 2 + [behave] of link 1 3 + [behave] of link 2 0 + [behave] of link 2 1 + [behave] of link 2 3 + [behave] of link 3 0 + [behave] of link 3 1 + [behave] of link 3 2) / 12)
  set reciprocity-01 abs ([behave] of link 0 1 - [behave] of link 1 0)
  set reciprocity-02 abs ([behave] of link 0 2 - [behave] of link 2 0)
  set reciprocity-03 abs ([behave] of link 0 3 - [behave] of link 3 0)
  set reciprocity-12 abs ([behave] of link 1 2 - [behave] of link 2 1)
  set reciprocity-13 abs ([behave] of link 1 3 - [behave] of link 3 1)
  set reciprocity-23 abs ([behave] of link 2 3 - [behave] of link 3 2)
end


;;refreshes the display for the model based on the chooser values
to refresh
  ;;displays current tasks, hides non-current tasks. Repositions all tasks into correct task-slots
  ask jobs with [(teaming-episode = 1) and (hidden? = false) and not((start-time <= time) and (start-time + duration > time))] [
    if (ycor = -15) [set task-slot-1-full 0]
    if (ycor = -12) [set task-slot-2-full 0]
    if (ycor = -9) [set task-slot-3-full 0]
    if (ycor = -6) [set task-slot-4-full 0]
    hide-turtle
  ]
  ask jobs with [(hidden? = true) and (teaming-episode = 1) and (start-time <= time) and (start-time + duration > time)] [
    ifelse (task-slot-1-full = 0) [
      set ycor -15
      set task-slot-1-full 1]
    [ifelse (task-slot-2-full = 0) [
      set ycor -12
      set task-slot-2-full 1]
    [ifelse (task-slot-3-full = 0) [
      set ycor -9
      set task-slot-3-full 1]
    [if (task-slot-4-full = 0) [
      set ycor -6
      set task-slot-4-full 1]]]]
    show-turtle
  ]
  ;;colors astronauts based upon the current tasks
  ask astronauts [set color white]
  ask jobs with [(hidden? = false) and (teaming-episode = 1)] [
    set temp-color-store color
    if (assigned-to-cmd = 1) [ask astronaut 0 [set color temp-color-store]]
    if (assigned-to-fe = 1) [ask astronaut 1 [set color temp-color-store]]
    if (assigned-to-ms1 = 1) [ask astronaut 2 [set color temp-color-store]]
    if (assigned-to-ms2 = 1) [ask astronaut 3 [set color temp-color-store]]
  ]
  ;;displays the correct type of ties
  if (displayn = "Positive affect")[display-paffect]
  if (displayn = "Negative affect")[display-naffect]
  if (displayn = "Informational ties")[display-inform]
  if (displayn = "Behavioral ties")[display-behave]
  ;;displays the current time
  ask patch 15 15 [
    set plabel time
  ]
end




;; The main simulation routine for the program
to go
  ;;steps forward in model time
  update-paffect
  update-naffect
  update-inform
  update-behave
  set time (time + 5) ;;time stored in five minute increments (one twelth of an hour)
  refresh
  tick
end


;; A subroutine for importing jobs from csv
to import-jobs
  ;; open a file on the system
  let filename "CrewSchedule.csv"
  file-open filename

  ;; parses the file
  let header csv:from-row file-read-line
  while [ not file-at-end? ] [
    let items csv:from-row file-read-line
    create-jobs 1 [
      ;; not visible until (ticks = start-time)
      hide-turtle

      ;; make the tasks have a box shape
      set shape "box"
      set size 3

      set start-time item 0 items
      set duration item 1 items
      set assigned-to-CMD item 2 items
      set assigned-to-FE item 3 items
      set assigned-to-MS1 item 4 items
      set assigned-to-MS2 item 5 items
      set teaming-episode item 6 items

      set xcor 15
      set ycor 0
    ]
  ]
  ;; import complete, so close the file
  file-close
  set imported-jobs true
end
@#$#@#$#@
GRAPHICS-WINDOW
559
10
998
470
16
16
13.0
1
16
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
560
479
780
512
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
790
479
998
512
import jobs
import-jobs
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
560
521
779
554
go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
790
520
998
553
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
11
10
548
158
Affect of CMD
Time
Affect
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"CMD -> MS1" 1.0 0 -16777216 true "" "plotxy time [affect] of link 0 2"
"CMD -> MS2" 1.0 0 -7500403 true "" "plotxy time [affect] of link 0 3"
"CMD -> FE" 1.0 0 -2674135 true "" "plotxy time [affect] of link 0 1"

PLOT
12
170
547
313
Affect of MS1
Time
Affect
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"MS1 -> CMD" 1.0 0 -16777216 true "" "plotxy time [affect] of link 2 0"
"MS1 -> MS2" 1.0 0 -7500403 true "" "plotxy time [affect] of link 2 3"
"MS1 -> FE" 1.0 0 -2674135 true "" "plotxy time [affect] of link 2 1"

PLOT
10
325
548
469
Affect of MS2
Time
Affect
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"MS2 -> CMD" 1.0 0 -16777216 true "" "plotxy time [affect] of link 3 0"
"MS2 -> MS1" 1.0 0 -7500403 true "" "plotxy time [affect] of link 3 2"
"MS2 -> FE" 1.0 0 -2674135 true "" "plotxy time [affect] of link 3 1"

PLOT
10
480
550
612
Affect of FE
Time
Affect
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"FE -> CMD" 1.0 0 -16777216 true "" "plotxy time [affect] of link 1 0"
"FE -> MS1" 1.0 0 -7500403 true "" "plotxy time [affect] of link 1 2"
"FE -> MS2" 1.0 0 -2674135 true "" "plotxy time [affect] of link 1 3"

PLOT
1009
10
1500
284
Mean Global Affect
Time
Affect
0.0
1.0
0.0
1.0
true
false
"" ""
PENS
"affect" 1.0 0 -16777216 true "" "plotxy time global-affect"

PLOT
1008
296
1499
552
Reciprocity (Absolute Difference in Affect)
Time
Reciprocity
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"CMD-MS1" 1.0 0 -16777216 true "" "plotxy time reciprocity-02"
"CMD-MS2" 1.0 0 -7500403 true "" "plotxy time reciprocity-03"
"CMD-FE" 1.0 0 -2674135 true "" "plotxy time reciprocity-01"
"MS1-MS2" 1.0 0 -955883 true "" "plotxy time reciprocity-23"
"MS1-FE" 1.0 0 -6459832 true "" "plotxy time reciprocity-12"
"MS2-FE" 1.0 0 -15575016 true "" "plotxy time reciprocity-13"

CHOOSER
560
563
998
608
displayn
displayn
"Positive affect" "Negative affect" "Informational ties" "Behavioral ties"
0

BUTTON
1007
563
1099
609
Refresh
refresh
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

astronaut
false
15
Polygon -1 true true 105 90 105 30 120 15 180 15 195 30 195 90 120 90
Polygon -1 true true 105 90 120 195 90 285 105 285 135 285 150 225 165 285 195 285 210 285 180 195 195 90
Polygon -1 true true 195 90 240 150 225 180 165 105
Polygon -1 true true 105 90 60 150 75 180 135 105
Circle -16777216 true false 117 27 66
Rectangle -16777216 true false 120 180 180 195
Circle -2674135 true false 120 150 30
Circle -13345367 true false 120 120 30
Polygon -7500403 true false 60 150 45 180 75 180 60 150
Polygon -7500403 true false 240 150 225 180 255 180 240 150
Line -16777216 false 60 150 75 180
Line -16777216 false 225 180 240 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 6.0-M6
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

curvy
1.25
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
